/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.Objects;
import java.util.Optional;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.DslBindingBuilder;
import org.gradle.api.internal.plugins.DslBindingBuilderInternal;
import org.gradle.api.internal.plugins.HasBuildModel;
import org.gradle.api.internal.plugins.SoftwareFeatureBinding;
import org.gradle.api.internal.plugins.SoftwareFeatureTransform;
import org.gradle.api.internal.plugins.TargetTypeInformation;
import org.gradle.internal.Cast;
import org.gradle.util.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultDslBindingBuilder<T extends HasBuildModel<V>, V extends BuildModel>
implements DslBindingBuilderInternal<T, V> {
    private final Class<T> dslType;
    private final TargetTypeInformation<?> targetDefinitionType;
    private final Class<V> buildModelType;
    private final Path path;
    private final SoftwareFeatureTransform<?, ?, ?> transform;
    private @Nullable Class<?> dslImplementationType;
    private @Nullable Class<?> buildModelImplementationType;

    public DefaultDslBindingBuilder(Class<T> dslType, Class<V> buildModelType, TargetTypeInformation<?> targetDefinitionType, Path path, SoftwareFeatureTransform<T, V, ?> transform) {
        this.targetDefinitionType = targetDefinitionType;
        this.dslType = dslType;
        this.buildModelType = buildModelType;
        this.path = path;
        this.transform = transform;
    }

    private static <T extends HasBuildModel<V>, V extends BuildModel> SoftwareFeatureBinding<T, V> bindingOf(final Class<T> dslType, final @Nullable Class<? extends T> dslImplementationType, final Path path, final TargetTypeInformation<?> targetDefinitionType, final Class<V> buildModelType, final @Nullable Class<? extends V> buildModelImplementationType, final SoftwareFeatureTransform<T, ?, V> transform) {
        return new SoftwareFeatureBinding<T, V>(){

            @Override
            public TargetTypeInformation<?> targetDefinitionType() {
                return targetDefinitionType;
            }

            @Override
            public Class<T> getDslType() {
                return dslType;
            }

            @Override
            public Optional<Class<? extends T>> getDslImplementationType() {
                return Optional.ofNullable(dslImplementationType);
            }

            @Override
            public SoftwareFeatureTransform<T, ?, V> getTransform() {
                return transform;
            }

            @Override
            public Class<V> getBuildModelType() {
                return buildModelType;
            }

            @Override
            public Optional<Class<? extends V>> getBuildModelImplementationType() {
                return Optional.ofNullable(buildModelImplementationType);
            }

            @Override
            public String getName() {
                return Objects.requireNonNull(path.getName());
            }
        };
    }

    @Override
    public DslBindingBuilder<T, V> withDefinitionImplementationType(Class<? extends T> implementationType) {
        this.dslImplementationType = implementationType;
        return this;
    }

    @Override
    public DslBindingBuilder<T, V> withBuildModelImplementationType(Class<? extends V> implementationType) {
        this.buildModelImplementationType = implementationType;
        return this;
    }

    @Override
    public SoftwareFeatureBinding<T, V> build() {
        if (this.dslImplementationType != null && !this.dslType.isAssignableFrom(this.dslImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.dslImplementationType + " is not a subtype of dsl type " + this.dslType);
        }
        if (this.buildModelImplementationType != null && !this.buildModelType.isAssignableFrom(this.buildModelImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.buildModelImplementationType + " is not a subtype of build model type " + this.buildModelType);
        }
        return DefaultDslBindingBuilder.bindingOf(this.dslType, (Class)Cast.uncheckedCast(this.dslImplementationType), this.path, this.targetDefinitionType, this.buildModelType, (Class)Cast.uncheckedCast(this.buildModelImplementationType), (SoftwareFeatureTransform)Cast.uncheckedCast(this.transform));
    }
}

